local t = Def.ActorFrame {};

t[#t+1] = Def.ActorFrame {
	-- Color layers
	Def.ActorFrame { -- Color
		Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#1B2364"););
			OffCommand=cmd(smooth,1.2;diffuse,color("#000000"););
		};
	};
	
	Def.ActorFrame { -- Color
		Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#0027C4"););
			OnCommand=cmd(queuecommand,"Pulse");
			PulseCommand=cmd(diffusealpha,0;smooth,20;diffusealpha,1;smooth,20;diffusealpha,0;queuecommand,"Pulse";);
		};
	};
	LoadActor("_morestars") .. {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-50;blend,'BlendMode_Add';zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;);
		OnCommand=cmd(texcoordvelocity,0.0,.04;customtexturerect,0,0,SCREEN_WIDTH/780,SCREEN_HEIGHT/480;);
	};
	
	Def.ActorFrame { -- Color
		Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#000000");fadetop,1);
		};
	};
	
	
	-- Overlays
	LoadActor("Swirl") .. {
		InitCommand=cmd(Center;diffusealpha,1;);
		OnCommand=cmd(spin;effectmagnitude,0,0,12;);
	};

	LoadActor("_mist") .. {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;rotationy,0;rotationz,0;rotationx,0;zoomto,SCREEN_WIDTH*1.2,SCREEN_HEIGHT*1.1);
		OnCommand=cmd(texcoordvelocity,0.10,0;blend,'BlendMode_Add';diffusealpha,0.04;);
	};
		
	
	-- Pew pew
	LoadActor("_laser") .. {
		InitCommand=
			function(self)
				self:xy(SCREEN_CENTER_X, SCREEN_CENTER_Y)
			end,
		OnCommand=cmd(diffusealpha,0;queuecommand,"Pulse";);
		PulseCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1;sleep,3;smooth,1.5;diffusealpha,0;sleep,4;queuecommand,"Pulse";);
    };	
};

t[#t+1] = Def.ActorFrame {
	LoadActor("_subtitle") .. {
		InitCommand=cmd(zoom,0.8;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-55;);
		OnCommand=cmd(addy,-10;diffusealpha,0;zoomy,0.6;sleep,0.5;decelerate,0.3;diffusealpha,1;zoomy,0.8;addy,10);
		OffCommand=cmd(decelerate,0.3;addy,10;diffusealpha,0;);
	};	
	LoadActor("_tm") .. {
		InitCommand=cmd(zoom,0.8;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-102;);
		OnCommand=cmd(addy,20;diffusealpha,0;zoomy,1.2;zoomx,1.4;decelerate,0.7;diffusealpha,1;zoom,0.8;addy,-20);
		OffCommand=cmd(sleep,0.2;decelerate,0.6;rotationz,16;zoom,1.3;diffusealpha,0;);
	};
	LoadActor("_crest") .. {
		InitCommand=cmd(zoom,0.8;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+20;);
		OnCommand=cmd(diffusealpha,0;addy,20;smooth,0.2;addy,-20;diffusealpha,1;);
		OffCommand=cmd(decelerate,0.3;addy,10;diffusealpha,0;);
	};
	LoadActor("_glowcrest") .. {
		InitCommand=cmd(zoom,0.8;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+20;);
		OnCommand=cmd(diffusealpha,0;sleep,0.2;queuecommand,"Pulse";);
		OffCommand=cmd(stoptweening;smooth,0.2;diffusealpha,0;);
		PulseCommand=cmd(diffusealpha,1;diffuseshift;effectclock,'beat';effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.6"));
    };	
};

-- Version info on top corner

t[#t+1] = Def.ActorFrame {
	OnCommand=cmd(diffusealpha,0;smooth,0.4;diffusealpha,1;);
	OffCommand=cmd(smooth,0.4;diffusealpha,0;);
		Def.BitmapText { 
			Font= "_exo2 semi bold 24px",
			Text= "Songs:",
			InitCommand= function(self) self:shadowlength(1):zoom(0.6):xy(16,24):diffuse(color("#FFFFFF")):horizalign(left) end
		};
		Def.BitmapText { 
			Font= "Common normal",
			Text= tostring(SONGMAN:GetNumSongs()), 
			InitCommand= function(self) self:shadowlength(1):zoom(0.6):xy(65,24):diffuse(color("#FFFFFF")):horizalign(left) end
		};
	};
	
t[#t+1] = Def.ActorFrame {
	OnCommand=cmd(diffusealpha,0;smooth,0.4;diffusealpha,1;);
	OffCommand=cmd(smooth,0.4;diffusealpha,0;);
		Def.BitmapText { 
			Font= "_exo2 semi bold 24px",
			Text= "Courses:",
			InitCommand= function(self) self:shadowlength(1):zoom(0.6):xy(16,44):diffuse(color("#FFFFFF")):horizalign(left) end
		};
		Def.BitmapText { 
			Font= "Common normal",
			Text= tostring(SONGMAN:GetNumCourses()), 
			InitCommand= function(self) self:shadowlength(1):zoom(0.6):xy(77,44):diffuse(color("#FFFFFF")):horizalign(left) end
		};
	};	
	
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_RIGHT-16);
	OnCommand=cmd(diffusealpha,0;smooth,0.4;diffusealpha,1;);
	OffCommand=cmd(smooth,0.4;diffusealpha,0;);
		Def.BitmapText { 
			Font= "_exo2 semi bold 24px",
			Text= string.format("StepMania %s", ProductVersion()), 
			InitCommand= function(self) self:shadowlength(1):zoom(0.75):y(24):diffuse(color("#FFFFFF")):horizalign(right) end
		};
	};
	
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(y,SCREEN_BOTTOM-16);
	OnCommand=cmd(diffusealpha,0;smooth,0.4;diffusealpha,1;);
	OffCommand=cmd(smooth,0.4;diffusealpha,0;);
		Def.BitmapText { 
			Font= "_kelson sans 24px",
			Text= "Theme Version 1.6",
			InitCommand= function(self) self:shadowlength(1):zoom(0.6):x(_screen.cx):diffuse(color("#FFFFFF")):horizalign(center) end
		};
	};		

return t;

